// Taper Sweep.js
//
// v.20090325 first version.
// v.20090326 UV coord added. flip bug fixed.
// v.20090326b flip bug fixed. 
// v.20090330 changed flip calculation.
// v.20090330b taper oscillation added.
// v.20090330c path scale bug fixed.
// v.20090406 fixed a problem when using with suvdiv mod.
// v.20100130 fixed a problem when using on 5.2+
// v.20111007 fixed animating bug

var Vec3D_len = function() {
    if( arguments.length == 1)
        return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
    var p = arguments[1].sub(arguments[0]);
    return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
        var l = arguments[0].norm();
        if( l != 0) 
            return arguments[0].multiply(1/l);
        return arguments[0];
}
/*
Vec3D.prototype.toString = function() {
    return "(" + this.x.toFixed(8) + ", " + this.y.toFixed(8) + ", " + this.z.toFixed(8) + ")";
}
if( !Vec3D.len) {
    // returns a Vec3D as a result
    Vec3D.prototype.len = function() {
        if( arguments.length == 0)
            return Math.sqrt( this.x*this.x + this.y*this.y + this.z*this.z );
        var p = arguments[0].sub(this);
        return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
    }
}
if( !Vec3D.normalize) {
    // returns a Vec3D as a result
    Vec3D.prototype.normalize = function() {
        var l = this.norm();
        if( l != 0) 
            return this.multiply(1/l);
        return this;
    }
}
if( !Vec3D.dot) {
    Vec3D.prototype.dot = function(other) {
        return this.x*other.x + this.y*other.y + this.z*other.z;
    }
}
if( !Vec3D.cross) {
    // returns a Vec3D as a result
    Vec3D.prototype.cross = function(other) {
        var xh = this.y * other.z - other.y * this.z;
        var yh = this.z * other.x - other.z * this.x;
        var zh = this.x * other.y - other.x * this.y;
        return new Vec3D(xh,yh,zh);
    }
}
*/

var spl_hol = [];
var spl_list = [];

//
var prY_hol = [];
var prY_list = [];
var prX_hol = [];
var prX_list = [];

var mat_scY;
var mat_scX;

// static value, pre-calculated;
var radian_p = 180/Math.PI;

function buildUI(obj){
	obj.setParameter("name","Taper Sweep");
	
	obj.addParameterInt("steps",12,1,10000,true,true);

	obj.addParameterBool("flip normal",false,false,true,true,true);
	obj.addParameterSelector("cover",["none","front","back","both"],true,true);
	obj.addParameterBool("meshed cover",false,false,true,true,true);
	obj.addParameterSelector("profile rotation",["0","180"],true,true);
	
	obj.addParameterSeparator("Taper");
	obj.addParameterFloat("scale factor", 1.0, 0.0, 1000.0, true, true);
	obj.addParameterBool("scale prop.", 1, 0, 1, true, true);
	obj.addParameterBool("relative pos.", false, false, true, true, true);
	obj.addParameterFloat("taper oscillation",1.0,0.0,1000.0,true,true);
	
	obj.addParameterSeparator("Smooth");
	obj.addParameterSelector("smooth",["normalFlat","normalPhong","normalContraint"],true,true);
	obj.addParameterFloat("smooth angle",45,1,180,true,true);
	
	obj.setCreatorObj(true);
}

function cacheScaleSpline(obj, o_i, p_i) {
	var sc = obj.childAtIndex(o_i);
	var flag = false;
	var hol = [];
	var list = [];
	//
	if (sc.family() == SPLINEFAMILY) {
		var c_sc = sc.modCore();
		if (c_sc.pathCount() > p_i) {
			hol = c_sc.cache(p_i);
			if (hol) {
				calcSplineLength(hol, list);
				flag = true;
			}
		} else if (c_sc.pathCount() > 0) {
			hol = c_sc.cache(0);
			if (hol) {
				calcSplineLength(hol, list);
				flag = true;
			}
		}
		if (hol) {
			if (o_i == 2) { // Y scale
				mat_scY = sc.objMatrix();
				prY_hol = hol;
				prY_list = list;
			} else { // X scale
				mat_scX = sc.objMatrix();
				prX_hol = hol;
				prX_list = list;
			}
		}
	}
	return flag;
}

function buildObject(obj) {
	//print('----');
	var n = obj.childCount();
	if (n > 1) {
		var prof = obj.childAtIndex(0); // getting profile
		var path = obj.childAtIndex(1); // getting path
		if (prof.family() != SPLINEFAMILY || path.family() != SPLINEFAMILY) return;
		
		var c_prof = prof.modCore();
		var c_path = path.modCore();
		var mat_prof = prof.objMatrix();
		var mat_path = path.objMatrix();
		
		var path_rot = path.getParameter("rotation");
		var mat_path_rot = new Mat4D(ROTATE_HPB, path_rot.x, path_rot.y, path_rot.z);
		//
		var count_path = c_path.pathCount();
		var count_prof = c_prof.pathCount();
		var p_i, p_j;
		
		if (c_prof.pathCount() < 1 && c_path.pathCount() < 1) return;
		
		obj.setParameter("normalType",obj.getParameter("smooth"),false);
		obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
		
		var core = obj.core();
		var steps = obj.getParameter("steps");
		var flip_normal = obj.getParameter("flip normal");
		var scale_prop = obj.getParameter("scale prop.");
		var rel_pos = obj.getParameter("relative pos.");
		var prof_rot = parseInt(obj.getParameter("profile rotation"));
		var cover_type = obj.getParameter("cover");
		var meshed_cover = obj.getParameter("meshed cover");
		//
		var osc = obj.getParameter("taper oscillation");
		
		// for calculation in loop
		var p_dir = new Vec3D();
		
		//
		var vertexCount = 0;
		
		for (p_i = 0;p_i < count_path;p_i++) {
			// initialize
			spl_hol = spl_list = [];
			prY_hol = prY_list = [];
			prX_hol = prX_list = [];
			//
			spl_hol = c_path.cache(p_i);
			var i,j;
			var flag_scY = false;
			var flag_scX = false;
			//
			if (n > 2) { // if there is a spline as 3rd child, script treats it as scale parameter for y( x ).
				flag_scY = cacheScaleSpline(obj, 2, p_i);
				if (flag_scY) {
					var scale_fac = obj.getParameter("scale factor");
				}
				if (n > 3) {
					flag_scX = cacheScaleSpline(obj, 3, p_i);
				}
			}
			//
			calcSplineLength(spl_hol, spl_list);
			//
			for (p_j = 0;p_j < count_prof;p_j++) {
				
				var ca_prof = c_prof.cache(p_j);
				var prof_len = ca_prof.length;
				
				//if (ca_prof[0].len( ca_prof[prof_len-1] ) == 0 ) {
				if (Vec3D_len( ca_prof[0], ca_prof[prof_len-1] ) == 0) {
					var prof_size = prof_len - 1;
					//var prof_size = prof_len;
				} else {
					var prof_size = prof_len;
				}
				
				// initialize
				p_dir.x = p_dir.y = p_dir.z = 0;
				
				vertexCount = core.vertexCount();
				
				var vi = 0;
				var vi_last = 0; // for closed spline path
				
				var prof_start = 0;
				var prof_start_old = 0;
				
				for (i = 0;i <= steps;i++) {
					//var p_vec = ca_path[i];
					var p_vec = pointFromPercentage(spl_hol, spl_list,i/steps);
					//
					if (i == 0) {
						var dir_vec = pointFromPercentage(spl_hol, spl_list, (i+1)/steps);
						//
						p_dir = dir_vec.sub(p_vec);
						//p_dir = p_dir.normalize();
						p_dir = Vec3D_normalize( p_dir );
					} else if (i == steps) {
						var dir_vec = pointFromPercentage(spl_hol, spl_list, (i-1)/steps);
						//
						p_dir = p_vec.sub(dir_vec);
						//p_dir = p_dir.normalize();
						p_dir = Vec3D_normalize( p_dir );
					} else {
						var dir1_vec = pointFromPercentage(spl_hol, spl_list, (i-1)/steps);
						var dir2_vec = pointFromPercentage(spl_hol, spl_list, (i+1)/steps);
						//
						p_dir = dir2_vec.sub(dir1_vec);
						//p_dir = p_dir.normalize();
						p_dir = Vec3D_normalize( p_dir );
					}
					//
					p_vec = mat_path.multiply(p_vec);
					//
					if (i == 0) {
						var vec_start = p_vec;
					}
					
					// calc rotation
					var phi = Math.atan2(p_dir.x, p_dir.z)*radian_p;
					var theta = Math.acos(p_dir.y)*radian_p;
					
					switch(prof_rot) {
						case 0 : // b 0
							var mat_rot = new Mat4D(ROTATE_HPB, phi, theta+90, 0);
							break;
						case 1 : // b 180
							var mat_rot = new Mat4D(ROTATE_HPB, phi, theta+90, 180);
							break;
					}
					//mat_rot = mat_path.multiply(mat_rot);
					mat_rot = mat_path_rot.multiply(mat_rot);
					
					// taper X/Y
					if (flag_scY) {
						var pr = i/steps*osc;
						while (pr > 1) {
							pr -= 1.0;
						}
						
						var sclY = pointFromPercentage(prY_hol, prY_list, pr);
						sclY = mat_scY.multiply(sclY);
						if (rel_pos) {
							sclY = sclY.sub(mat_path.multiply(p_vec));
						}
						sclY = sclY.multiply(scale_fac);
						
						if (scale_prop) {
							var scl = new Vec3D(sclY.y, sclY.y, 1);
						} else {
							var scl = new Vec3D(sclY.x, sclY.y, 1);
						}
						if (flag_scX) {
							var sclX = pointFromPercentage(prX_hol, prX_list, pr);
							sclX = mat_scX.multiply(sclX);
							if (rel_pos) {
								sclX = sclX.sub(mat_path.multiply(p_vec));
							}
							sclX = sclX.multiply(scale_fac);
							scl.x = sclX.x;
						}
						var mat_tap = new Mat4D(SCALE, scl.x, scl.y, 1);
					} else {
						var mat_tap = new Mat4D(SCALE, 1, 1, 1);
					}
					
					var mat_fin = mat_rot.multiply( mat_tap );
					//print('-- prof_start --');
					for (j = 0;j < prof_len;j++) {
						var vec = mat_fin.multiply( mat_prof.multiply( ca_prof[j] ));
						
						if (j == prof_len - 1 && prof_size != prof_len) { // 
							//
							//if (i == steps && vec_start.len( p_vec ) == 0) { // if closed path spline
							if (i == steps && Vec3D_len( vec_start, p_vec ) == 0) {
								var vec_cl = p_vec.add(vec).add(core.vertex(j + vertexCount - 1)).multiply(1/2);
								//core.setVertex(j + vertexCount - 1, vec_cl);
								//print('va:'+(j + vertexCount - 1)+','+vi+','+prof_start+','+prof_start_old);
								if (i != 0 && j != 0) {
									var vi_list = [vertexCount + j - 1, vertexCount, prof_start_old, prof_start];
									if (flip_normal) vi_list = vi_list.reverse();
									var pi = core.addIndexPolygon(4, vi_list);
									//print('va:'+vi_list);
									core.setUVCoord(pi, 0, new Vec2D( j   /(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 1, new Vec2D((j-1)/(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 2, new Vec2D((j-1)/(prof_len-1), (i-1)/steps));
									core.setUVCoord(pi, 3, new Vec2D( j   /(prof_len-1), (i-1)/steps));
								}
							} else {
								//vi = core.addVertex(false, p_vec.add(vec) );
								if (i != 0 && j != 0) {
									//var vi_list = [vi-1, vi, vi-prof_size, vi-prof_size-1];
									var vi_list = [vi, prof_start, prof_start_old, vi - prof_size];
									if (flip_normal) vi_list = vi_list.reverse();
									var pi = core.addIndexPolygon(4, vi_list);
									//print('vi:'+vi_list);
									core.setUVCoord(pi, 0, new Vec2D( j   /(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 1, new Vec2D((j-1)/(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 2, new Vec2D((j-1)/(prof_len-1), (i-1)/steps));
									core.setUVCoord(pi, 3, new Vec2D( j   /(prof_len-1), (i-1)/steps));
								}
							}
							//
						} else { // 
							//if (i == steps && vec_start.len( p_vec ) == 0) { // if closed path spline
							if (i == steps && Vec3D_len( vec_start, p_vec ) == 0) {
								var vec_cl = p_vec.add(vec).add(core.vertex(j + vertexCount)).multiply(1/2);
								core.setVertex(j + vertexCount, vec_cl);
								if (i != 0 && j != 0) {
									var vi_list = [vertexCount + j - 1, vertexCount + j, vi_last - prof_size + j + 1, vi_last - prof_size + j];
									if (flip_normal) vi_list = vi_list.reverse();
									var pi = core.addIndexPolygon(4, vi_list);
									//print('vb:'+vi_list);
									core.setUVCoord(pi, 0, new Vec2D( j   /(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 1, new Vec2D((j-1)/(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 2, new Vec2D((j-1)/(prof_len-1), (i-1)/steps));
									core.setUVCoord(pi, 3, new Vec2D( j   /(prof_len-1), (i-1)/steps));
								}
							} else {
								vi = core.addVertex(false, p_vec.add(vec) );
								if (i != 0 && j != 0) {
									var vi_list = [vi-1, vi, vi-prof_size, vi-prof_size-1];
									if (flip_normal) vi_list = vi_list.reverse();
									var pi = core.addIndexPolygon(4, vi_list);
									//print('vj:'+vi_list);
									core.setUVCoord(pi, 0, new Vec2D( j   /(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 1, new Vec2D((j-1)/(prof_len-1),  i   /steps));
									core.setUVCoord(pi, 2, new Vec2D((j-1)/(prof_len-1), (i-1)/steps));
									core.setUVCoord(pi, 3, new Vec2D( j   /(prof_len-1), (i-1)/steps));
								}
							}
						}
						
						if (j == 0) { // 
							prof_start_old = prof_start;
							prof_start = vi;
						}
					}
					// 
					vi_last = vi;
					
					// cover
					if (i == steps && (cover_type == '1' || cover_type == '3')) {
						var vi_list = [];
						for (j = 0;j < prof_len;j++) {
							vi_list.push(vertexCount+j);
						}
						if (!meshed_cover) {
							for (j = 0;j < prof_len;j++) {
								vi_list[j] = core.addVertex(false, core.vertex(vi_list[j]));
							}
						}
						if (flip_normal) vi_list = vi_list.reverse();
						var cpi = core.addIndexPolygon(prof_size, vi_list);
						core.setActivePolygonSelection(1);
						core.setPolygonSelection(cpi, true);
					}
					if (i == steps && (cover_type == '2' || cover_type == '3')) {
						var vi_list = [];
						for (j = 0;j < prof_len;j++) {
							if (meshed_cover) {
								vi_list.push(vi - j);
							} else {
								vi_list.push(core.addVertex(false, core.vertex(vi - j)));
							}
						}
						if (flip_normal) vi_list = vi_list.reverse();
						var cpi = core.addIndexPolygon(prof_size, vi_list);
						core.setActivePolygonSelection(1);
						core.setPolygonSelection(cpi, true);
					}
				}
			}
			
			core.setActivePolygonSelection(0);
		} // end of path loop
	}
}

// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D
function calcSplineLength(points,lst) {
    if (!points) {
        lst = [];
        return accum;
    }
	var l = points.length;
	var i;
	var accum = 0;
	lst[0] = 0;
	for(i=0;i<l-1;i++) {
		var p = points[i+1].sub(points[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		lst[i+1] = accum;
	}
	for(i=0;i<l;i++) {
		lst[i] = lst[i]/accum;
	}
	return accum;
}

// percent must be >= 0 and <= 1
function pointFromPercentage(path,lst,percent) {
    if (!path || path.length < 1) return new Vec3D();
    
	while( percent < 0) percent += 1;
	while( percent > 1) percent -= 1;
	var i,hi = (path)? path.length-1 : 0;
	var lo = 0;
	var d = percent;
	while(hi-lo > 1) {
		i = Math.floor((hi+lo)/2);
		if( percent <= lst[i] ) {
			hi = i;
			continue;
		}
		if( percent > lst[i] ) {
			lo = i;
		}
	}
	i = hi;
			
	var p1 = path[i-1];
	var p2 = path[i];
	// convert d into a percentage between the two points
	d = (d - lst[i-1])/(lst[i] - lst[i-1]);
	p1 = p1.multiply(1-d).add(p2.multiply(d));
	return p1;
}

